
<?php $__env->startSection('content'); ?>

<error-message key="not_permitted" />

<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4><?php echo e(__('db.Group Permission')); ?></h4>
                    </div>
                    <?php echo Form::open(['route' => 'role.setPermission', 'method' => 'post']); ?>

                    <div class="card-body">
                    	<input type="hidden" name="role_id" value="<?php echo e($lims_role_data->id); ?>" />
						<div class="table-responsive">
						    <table class="table table-bordered permission-table">
						        <thead>
						        <tr>
						            <th colspan="6" class="text-center"><?php echo e($lims_role_data->name); ?> <?php echo e(__('db.Group Permission')); ?></th>
						        </tr>
						        <tr>
						            <th rowspan="2" class="text-center">Module Name</th>
						            <th colspan="5" class="text-center">
						            	<div class="checkbox">
						            		<input type="checkbox" id="select_all">
						            		<label for="select_all"><?php echo e(__('db.Permissions')); ?></label>
						            	</div>
						            </th>
						        </tr>
						        <tr>
						            <th class="text-center"><?php echo e(__('db.View')); ?></th>
						            <th class="text-center"><?php echo e(__('db.add')); ?></th>
						            <th class="text-center"><?php echo e(__('db.edit')); ?></th>
						            <th class="text-center"><?php echo e(__('db.delete')); ?></th>
									<th class="text-center"><?php echo e(__('db.import')); ?></th>
						        </tr>
						        </thead>
						        <tbody>
						        <?php
									$permissions = ['index', 'add', 'edit', 'delete', 'import'];
									?>

									<tr>
										<td><?php echo e(__('db.category')); ?></td>
										<?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<?php $key = "categories-{$perm}"; ?>
											<td class="text-center">
												<div class="checkbox icheckbox_square-blue">
													<input type="checkbox"
														value="1"
														id="<?php echo e($key); ?>"
														name="<?php echo e($key); ?>"
														<?php echo e(in_array($key, $all_permission) ? 'checked' : ''); ?>>
													<label for="<?php echo e($key); ?>"></label>
												</div>
											</td>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</tr>

									<tr>
										<td><?php echo e(__('db.product')); ?></td>
										<?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<?php $key = "products-{$perm}"; ?>
											<td class="text-center">
												<div class="checkbox icheckbox_square-blue">
													<input type="checkbox"
														value="1"
														id="<?php echo e($key); ?>"
														name="<?php echo e($key); ?>"
														<?php echo e(in_array($key, $all_permission) ? 'checked' : ''); ?>>
													<label for="<?php echo e($key); ?>"></label>
												</div>
											</td>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</tr>

									<tr>
										<td><?php echo e(__('db.Purchase')); ?></td>
										<?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<?php $key = "purchases-{$perm}"; ?>
											<td class="text-center">
												<div class="checkbox icheckbox_square-blue">
													<input type="checkbox"
														value="1"
														id="<?php echo e($key); ?>"
														name="<?php echo e($key); ?>"
														<?php echo e(in_array($key, $all_permission) ? 'checked' : ''); ?>>
													<label for="<?php echo e($key); ?>"></label>
												</div>
											</td>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</tr>


						        <tr>
						            <td><?php echo e(__('db.Purchase Payment')); ?></td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("purchase-payment-index", $all_permission)): ?>
								                <input type="checkbox" value="1" id="purchase-payment-index" name="purchase-payment-index" checked />
								                <?php else: ?>
								                <input type="checkbox" value="1" id="purchase-payment-index" name="purchase-payment-index">
								                <?php endif; ?>
								                <label for="purchase-payment-index"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("purchase-payment-add", $all_permission)): ?>
								                <input type="checkbox" value="1" id="purchase-payment-add" name="purchase-payment-add" checked />
								                <?php else: ?>
								                <input type="checkbox" value="1" id="purchase-payment-add" name="purchase-payment-add">
								                <?php endif; ?>
								                <label for="purchase-payment-add"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("purchase-payment-edit", $all_permission)): ?>
								                <input type="checkbox" value="1" id="purchase-payment-edit" name="purchase-payment-edit" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="purchase-payment-edit" name="purchase-payment-edit">
								                <?php endif; ?>
								                <label for="purchase-payment-edit"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("purchase-payment-delete", $all_permission)): ?>
								                <input type="checkbox" value="1" id="purchase-payment-delete" name="purchase-payment-delete" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="purchase-payment-delete" name="purchase-payment-delete">
								                <?php endif; ?>
								                <label for="purchase-payment-delete"></label>
								            </div>
						            	</div>
						            </td>
									<td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
						            	</div>
						            </td>
						        </tr>

								<tr>
									<td><?php echo e(__('db.Sale')); ?></td>
									<?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<?php $key = "sales-{$perm}"; ?>
										<td class="text-center">
											<div class="checkbox icheckbox_square-blue">
												<input type="checkbox"
													value="1"
													id="<?php echo e($key); ?>"
													name="<?php echo e($key); ?>"
													<?php echo e(in_array($key, $all_permission) ? 'checked' : ''); ?>>
												<label for="<?php echo e($key); ?>"></label>
											</div>
										</td>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tr>


						        <tr>
						            <td><?php echo e(__('db.Sale Payment')); ?></td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("sale-payment-index", $all_permission)): ?>
								                <input type="checkbox" value="1" id="sale-payment-index" name="sale-payment-index" checked />
								                <?php else: ?>
								                <input type="checkbox" value="1" id="sale-payment-index" name="sale-payment-index">
								                <?php endif; ?>
								                <label for="sale-payment-index"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("sale-payment-add", $all_permission)): ?>
								                <input type="checkbox" value="1" id="sale-payment-add" name="sale-payment-add" checked />
								                <?php else: ?>
								                <input type="checkbox" value="1" id="sale-payment-add" name="sale-payment-add">
								                <?php endif; ?>
								                <label for="sale-payment-add"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("sale-payment-edit", $all_permission)): ?>
								                <input type="checkbox" value="1" id="sale-payment-edit" name="sale-payment-edit" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="sale-payment-edit" name="sale-payment-edit">
								                <?php endif; ?>
								                <label for="sale-payment-edit"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("sale-payment-delete", $all_permission)): ?>
								                <input type="checkbox" value="1" id="sale-payment-delete" name="sale-payment-delete" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="sale-payment-delete" name="sale-payment-delete">
								                <?php endif; ?>
								                <label for="sale-payment-delete"></label>
								            </div>
						            	</div>
						            </td>
									<td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
						            	</div>
						            </td>
						        </tr>

						        <tr class="expense-row">
						            <td><?php echo e(__('db.Expense')); ?></td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("expenses-index", $all_permission)): ?>
								                <input type="checkbox" value="1" id="expenses-index" name="expenses-index" checked />
								                <?php else: ?>
								                <input type="checkbox" value="1" id="expenses-index" name="expenses-index">
								                <?php endif; ?>
								                <label for="expenses-index"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("expenses-add", $all_permission)): ?>
								                <input type="checkbox" value="1" id="expenses-add" name="expenses-add" checked />
								                <?php else: ?>
								                <input type="checkbox" value="1" id="expenses-add" name="expenses-add">
								                <?php endif; ?>
								                <label for="expenses-add"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("expenses-edit", $all_permission)): ?>
								                <input type="checkbox" value="1" id="expenses-edit" name="expenses-edit" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="expenses-edit" name="expenses-edit">
								                <?php endif; ?>
								                <label for="expenses-edit"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("expenses-delete", $all_permission)): ?>
								                <input type="checkbox" value="1" id="expenses-delete" name="expenses-delete" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="expenses-delete" name="expenses-delete">
								                <?php endif; ?>
								                <label for="expenses-delete"></label>
								            </div>
						            	</div>
						            </td>
									<td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
						            	</div>
						            </td>
						        </tr>
								<tr class="income-row">
						            <td><?php echo e(__('db.Income')); ?></td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("incomes-index", $all_permission)): ?>
								                <input type="checkbox" value="1" id="incomes-index" name="incomes-index" checked />
								                <?php else: ?>
								                <input type="checkbox" value="1" id="incomes-index" name="incomes-index">
								                <?php endif; ?>
								                <label for="incomes-index"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("incomes-add", $all_permission)): ?>
								                <input type="checkbox" value="1" id="incomes-add" name="incomes-add" checked />
								                <?php else: ?>
								                <input type="checkbox" value="1" id="incomes-add" name="incomes-add">
								                <?php endif; ?>
								                <label for="incomes-add"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("incomes-edit", $all_permission)): ?>
								                <input type="checkbox" value="1" id="incomes-edit" name="incomes-edit" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="incomes-edit" name="incomes-edit">
								                <?php endif; ?>
								                <label for="incomes-edit"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("incomes-delete", $all_permission)): ?>
								                <input type="checkbox" value="1" id="incomes-delete" name="incomes-delete" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="incomes-delete" name="incomes-delete">
								                <?php endif; ?>
								                <label for="incomes-delete"></label>
								            </div>
						            	</div>
						            </td>
									<td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
						            	</div>
						            </td>
						        </tr>
						        <tr class="quotation-row">
						            <td><?php echo e(__('db.Quotation')); ?></td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("quotes-index", $all_permission)): ?>
								                <input type="checkbox" value="1" id="quotes-index" name="quotes-index" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="quotes-index" name="quotes-index">
								                <?php endif; ?>
								                <label for="quotes-index"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("quotes-add", $all_permission)): ?>
								                <input type="checkbox" value="1" id="quotes-add" name="quotes-add" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="quotes-add" name="quotes-add">
								                <?php endif; ?>
								                <label for="quotes-add"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("quotes-edit", $all_permission)): ?>
								                <input type="checkbox" value="1" id="quotes-edit" name="quotes-edit" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="quotes-edit" name="quotes-edit">
								                <?php endif; ?>
								                <label for="quotes-edit"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("quotes-delete", $all_permission)): ?>
								                <input type="checkbox" value="1" id="quotes-delete" name="quotes-delete" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="quotes-delete" name="quotes-delete">
								                <?php endif; ?>
								                <label for="quotes-delete"></label>
								            </div>
						            	</div>
						            </td>
									<td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
						            	</div>
						            </td>
						        </tr>

								<tr class="transfer-row">
									<td><?php echo e(__('db.Transfer')); ?></td>
									<?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<?php $key = "transfers-{$perm}"; ?>
										<td class="text-center">
											<div class="checkbox icheckbox_square-blue">
												<input type="checkbox"
													value="1"
													id="<?php echo e($key); ?>"
													name="<?php echo e($key); ?>"
													<?php echo e(in_array($key, $all_permission) ? 'checked' : ''); ?>>
												<label for="<?php echo e($key); ?>"></label>
											</div>
										</td>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tr>


						        <tr class="sale-return-row">
						            <td><?php echo e(__('db.Sale Return')); ?></td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("returns-index", $all_permission)): ?>
								                <input type="checkbox" value="1" id="returns-index" name="returns-index" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="returns-index" name="returns-index">
								                <?php endif; ?>
								                <label for="returns-index"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("returns-add", $all_permission)): ?>
								                <input type="checkbox" value="1" id="returns-add" name="returns-add" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="returns-add" name="returns-add">
								                <?php endif; ?>
								                <label for="returns-add"></label>
							                </div>
							            </div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("returns-edit", $all_permission)): ?>
								                <input type="checkbox" value="1" id="returns-edit" name="returns-edit" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="returns-edit" name="returns-edit">
								                <?php endif; ?>
								                <label for="returns-edit"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("returns-delete", $all_permission)): ?>
								                <input type="checkbox" value="1" id="returns-delete" name="returns-delete" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="returns-delete" name="returns-delete">
								                <?php endif; ?>
								                <label for="returns-delete"></label>
								            </div>
						            	</div>
						            </td>
									<td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
						            	</div>
						            </td>
						        </tr>

						        <tr class="purchase-return-row">
						            <td><?php echo e(__('db.Purchase Return')); ?></td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("purchase-return-index", $all_permission)): ?>
								                <input type="checkbox" value="1" id="purchase-return-index" name="purchase-return-index" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="purchase-return-index" name="purchase-return-index">
								                <?php endif; ?>
								                <label for="purchase-return-index"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("purchase-return-add", $all_permission)): ?>
								                <input type="checkbox" value="1" id="purchase-return-add" name="purchase-return-add" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="purchase-return-add" name="purchase-return-add">
								                <?php endif; ?>
								                <label for="purchase-return-add"></label>
								            </div>
						                </div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("purchase-return-edit", $all_permission)): ?>
								                <input type="checkbox" value="1" id="purchase-return-edit" name="purchase-return-edit" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="purchase-return-edit" name="purchase-return-edit">
								                <?php endif; ?>
								                <label for="purchase-return-edit"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
						                	<div class="checkbox">
								                <?php if(in_array("purchase-return-delete", $all_permission)): ?>
								                <input type="checkbox" value="1" id="purchase-return-delete" name="purchase-return-delete" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="purchase-return-delete" name="purchase-return-delete">
								                <?php endif; ?>
								                <label for="purchase-return-delete"></label>
								            </div>
						            	</div>
						            </td>
									<td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
						            	</div>
						            </td>
						        </tr>
						        <tr class="employee-row">
						            <td><?php echo e(__('db.Employee')); ?></td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("employees-index", $all_permission)): ?>
								                <input type="checkbox" value="1" id="employees-index" name="employees-index" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="employees-index" name="employees-index">
								                <?php endif; ?>
								                <label for="employees-index"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("employees-add", $all_permission)): ?>
								                <input type="checkbox" value="1" id="employees-add" name="employees-add" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="employees-add" name="employees-add">
								                <?php endif; ?>
								                <label for="employees-add"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("employees-edit", $all_permission)): ?>
								                <input type="checkbox" value="1" id="employees-edit" name="employees-edit" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="employees-edit" name="employees-edit">
								                <?php endif; ?>
								                <label for="employees-edit"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("employees-delete", $all_permission)): ?>
								                <input type="checkbox" value="1" id="employees-delete" name="employees-delete" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="employees-delete" name="employees-delete">
								                <?php endif; ?>
								                <label for="employees-delete"></label>
								            </div>
						            	</div>
						            </td>
									<td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
						            	</div>
						            </td>
						        </tr>
						        <tr>
						            <td><?php echo e(__('db.User')); ?></td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("users-index", $all_permission)): ?>
								                <input type="checkbox" value="1" id="users-index" name="users-index" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="users-index" name="users-index">
								                <?php endif; ?>
								                <label for="users-index"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("users-add", $all_permission)): ?>
								                <input type="checkbox" value="1" id="users-add" name="users-add" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="users-add" name="users-add">
								                <?php endif; ?>
								                <label for="users-add"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue checked" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("users-edit", $all_permission)): ?>
								                <input type="checkbox" value="1" id="users-edit" name="users-edit" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="users-edit" name="users-edit">
								                <?php endif; ?>
								                <label for="users-edit"></label>
								            </div>
						            	</div>
						            </td>
						            <td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
							                <div class="checkbox">
								                <?php if(in_array("users-delete", $all_permission)): ?>
								                <input type="checkbox" value="1" id="users-delete" name="users-delete" checked>
								                <?php else: ?>
								                <input type="checkbox" value="1" id="users-delete" name="users-delete">
								                <?php endif; ?>
								                <label for="users-delete"></label>
								            </div>
						            	</div>
						            </td>
									<td class="text-center">
						                <div class="icheckbox_square-blue" aria-checked="false" aria-disabled="false">
						            	</div>
						            </td>
						        </tr>

								<tr>
									<td><?php echo e(__('db.customer')); ?></td>
									<?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<?php $key = "customers-{$perm}"; ?>
										<td class="text-center">
											<div class="checkbox icheckbox_square-blue">
												<input type="checkbox"
													value="1"
													id="<?php echo e($key); ?>"
													name="<?php echo e($key); ?>"
													<?php echo e(in_array($key, $all_permission) ? 'checked' : ''); ?>>
												<label for="<?php echo e($key); ?>"></label>
											</div>
										</td>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tr>

								<tr>
									<td><?php echo e(__('db.Biller')); ?></td>
									<?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<?php $key = "billers-{$perm}"; ?>
										<td class="text-center">
											<div class="checkbox icheckbox_square-blue">
												<input type="checkbox"
													value="1"
													id="<?php echo e($key); ?>"
													name="<?php echo e($key); ?>"
													<?php echo e(in_array($key, $all_permission) ? 'checked' : ''); ?>>
												<label for="<?php echo e($key); ?>"></label>
											</div>
										</td>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tr>

								<tr>
									<td><?php echo e(__('db.Supplier')); ?></td>
									<?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<?php $key = "suppliers-{$perm}"; ?>
										<td class="text-center">
											<div class="checkbox icheckbox_square-blue">
												<input type="checkbox"
													value="1"
													id="<?php echo e($key); ?>"
													name="<?php echo e($key); ?>"
													<?php echo e(in_array($key, $all_permission) ? 'checked' : ''); ?>>
												<label for="<?php echo e($key); ?>"></label>
											</div>
										</td>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tr>

								
								<?php
									$permissions_data = include(resource_path('views/backend/role/permission_data.php'));
									$sidebar_permissions = $permissions_data['sidebar_permissions'];
								?>
								<tr>
						            <td><?php echo e(__('db.Sidebar')); ?></td>
						            <td class="report-permissions" colspan="5">
										<?php $__currentLoopData = $sidebar_permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<span>
												<div aria-checked="false" aria-disabled="false">
													<div class="checkbox">
														<?php if(in_array($key, $all_permission)): ?>
															<input type="checkbox" value="1" id=<?php echo e($key); ?> name=<?php echo e($key); ?> checked>
														<?php else: ?>
															<input type="checkbox" value="1" id=<?php echo e($key); ?> name=<?php echo e($key); ?>>
														<?php endif; ?>
														<label for=<?php echo e($key); ?> class="padding05"><?php echo e(__('db.' . $label)); ?> &nbsp;&nbsp;</label>
													</div>
												</div>
											</span>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</td>
								</tr>

						        <tr>
						            <td><?php echo e(__('db.dashboard')); ?></td>
						            <td class="report-permissions" colspan="5">
						            	<span>
								            <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("revenue_profit_summary", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="revenue_profit_summary" name="revenue_profit_summary" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="revenue_profit_summary" name="revenue_profit_summary">
							                    	<?php endif; ?>
								                    <label for="revenue_profit_summary" class="padding05"><?php echo e(__('db.Revenue and Profit Summary')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						            	</span>
						            	<span>
						            		<div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("cash_flow", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="cash_flow" name="cash_flow" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="cash_flow" name="cash_flow">
							                    	<?php endif; ?>
								                    <label for="cash_flow" class="padding05"><?php echo e(__('db.Cash Flow')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						            	</span>
						            	<span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("monthly_summary", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="monthly_summary" name="monthly_summary" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="monthly_summary" name="monthly_summary">
							                    	<?php endif; ?>
								                    <label for="monthly_summary" class="padding05"><?php echo e(__('db.Monthly Summary')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("yearly_report", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="yearly_report" name="yearly_report" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="yearly_report" name="yearly_report">
							                    	<?php endif; ?>
								                    <label for="yearly_report" class="padding05"><?php echo e(__('db.yearly report')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						            </td>
						        </tr>
								<tr>
						            <td><?php echo e(__('db.POS')); ?></td>
						            <td class="report-permissions" colspan="5">
										<span>
								            <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("cart-product-update", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="cart-product-update" name="cart-product-update" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="cart-product-update" name="cart-product-update">
							                    	<?php endif; ?>
								                    <label for="cart-product-update" class="padding05"><?php echo e(__('db.Cart Product Update')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						            	</span>
						            	<span>
								            <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("handle_discount", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="handle_discount" name="handle_discount" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="handle_discount" name="handle_discount">
							                    	<?php endif; ?>
								                    <label for="handle_discount" class="padding05"><?php echo e(__('db.Handle Discount')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						            	</span>
						            </td>
						        </tr>
								<tr>
									<td><?php echo e(__('db.Exports')); ?></td>
									<td class="report-permissions" colspan="5">
										<span>
								            <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("product_export", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="product_export" name="product_export" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="product_export" name="product_export">
							                    	<?php endif; ?>
								                    <label for="product_export" class="padding05"><?php echo e(__('db.Product Export')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						            	</span>
										<span>
								            <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("purchase_export", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="purchase_export" name="purchase_export" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="purchase_export" name="purchase_export">
							                    	<?php endif; ?>
								                    <label for="purchase_export" class="padding05"><?php echo e(__('db.Purchase Export')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						            	</span>
										<span>
								            <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("sale_export", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="sale_export" name="sale_export" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="sale_export" name="sale_export">
							                    	<?php endif; ?>
								                    <label for="sale_export" class="padding05"><?php echo e(__('db.Sale Export')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						            	</span>
										<span>
								            <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("customer_export", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="customer_export" name="customer_export" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="customer_export" name="customer_export">
							                    	<?php endif; ?>
								                    <label for="customer_export" class="padding05"><?php echo e(__('db.Customer Export')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						            	</span>
									</td>
								</tr>
						      	<tr class="accounting-row">
						            <td><?php echo e(__('db.Accounting')); ?></td>
						            <td class="report-permissions" colspan="5">
						            	<span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("account-index", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="account-index" name="account-index" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="account-index" name="account-index">
							                    	<?php endif; ?>
								                    <label for="account-index" class="padding05"><?php echo e(__('db.Account')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("money-transfer", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="money-transfer" name="money-transfer" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="money-transfer" name="money-transfer">
							                    	<?php endif; ?>
								                    <label for="money-transfer" class="padding05"><?php echo e(__('db.Money Transfer')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("balance-sheet", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="balance-sheet" name="balance-sheet" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="balance-sheet" name="balance-sheet">
							                    	<?php endif; ?>
								                    <label for="balance-sheet" class="padding05"><?php echo e(__('db.Balance Sheet')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
						                    	<div class="checkbox">
							                    	<?php if(in_array("account-statement", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="account-statement-permission" name="account-statement" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="account-statement-permission" name="account-statement">
							                    	<?php endif; ?>
								                    <label for="account-statement-permission" class="padding05"><?php echo e(__('db.Account Statement')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
										<span>
						                    <div aria-checked="false" aria-disabled="false">
						                    	<div class="checkbox">
							                    	<?php if(in_array("account-selection", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="account-selection-permission" name="account-selection" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="account-selection-permission" name="account-selection">
							                    	<?php endif; ?>
								                    <label for="account-selection-permission" class="padding05"><?php echo e(__('db.Account Selection')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						            </td>
						        </tr>
						        <tr class="hrm-row">
						            <td>HRM</td>
						            <td class="report-permissions" colspan="5">


										
										<span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("hrm-panel", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="hrm-panel" name="hrm-panel" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="hrm-panel" name="hrm-panel">
							                    	<?php endif; ?>
								                    <label for="hrm-panel" class="padding05"><?php echo e(__('db.HRM Panel')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>

                                        
										<span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("sale-agents", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="sale-agents" name="sale-agents" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="sale-agents" name="sale-agents">
							                    	<?php endif; ?>
								                    <label for="sale-agents" class="padding05"><?php echo e(__('db.Sale Agents')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>

                                        
						            	<span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("department", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="department" name="department" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="department" name="department">
							                    	<?php endif; ?>
								                    <label for="department" class="padding05"><?php echo e(__('db.Department')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>

                                        
                                        <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("designations", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="designations" name="designations" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="designations" name="designations">
							                    	<?php endif; ?>
								                    <label for="designations" class="padding05"><?php echo e(__('db.Designations')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>

                                        
                                        <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("shift", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="shift" name="shift" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="shift" name="shift">
							                    	<?php endif; ?>
								                    <label for="shift" class="padding05"><?php echo e(__('db.Shift')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>

                                        
                                        <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("overtime", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="overtime" name="overtime" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="overtime" name="overtime">
							                    	<?php endif; ?>
								                    <label for="overtime" class="padding05"><?php echo e(__('db.Overtime')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>

                                        
                                        <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("leave-type", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="leave-type" name="leave-type" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="leave-type" name="leave-type">
							                    	<?php endif; ?>
								                    <label for="leave-type" class="padding05"><?php echo e(__('db.Leave Type')); ?></label>
								                </div>
								            </div>
						                </span>

                                        
                                        <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("leave", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="leave" name="leave" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="leave" name="leave">
							                    	<?php endif; ?>
								                    <label for="leave" class="padding05"><?php echo e(__('db.Leave')); ?></label>
								                </div>
								            </div>
						                </span>


						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("attendance", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="attendance" name="attendance" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="attendance" name="attendance">
							                    	<?php endif; ?>
								                    <label for="attendance" class="padding05"><?php echo e(__('db.Attendance')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("payroll", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="payroll" name="payroll" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="payroll" name="payroll">
							                    	<?php endif; ?>
								                    <label for="payroll" class="padding05"><?php echo e(__('db.Payroll')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("holiday", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="holiday" name="holiday" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="holiday" name="holiday">
							                    	<?php endif; ?>
								                    <label for="holiday" class="padding05"><?php echo e(__('db.Holiday Approve')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						            </td>
						        </tr>
						        <tr class="report-row">
						            <td><?php echo e(__('db.Reports')); ?></td>
						            <td class="report-permissions" colspan="5">
						            	<span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("profit-loss", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="profit-loss" name="profit-loss" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="profit-loss" name="profit-loss">
							                    	<?php endif; ?>
								                    <label for="profit-loss" class="padding05"><?php echo e(__('db.Summary Report')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("best-seller", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="best-seller" name="best-seller" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="best-seller" name="best-seller">
							                    	<?php endif; ?>
								                    <label for="best-seller" class="padding05"><?php echo e(__('db.Best Seller')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("daily-sale", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="daily-sale" name="daily-sale" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="daily-sale" name="daily-sale">
							                    	<?php endif; ?>
								                    <label for="daily-sale" class="padding05"><?php echo e(__('db.Daily Sale')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("monthly-sale", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="monthly-sale" name="monthly-sale" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="monthly-sale" name="monthly-sale">
							                    	<?php endif; ?>
								                    <label for="monthly-sale" class="padding05"><?php echo e(__('db.Monthly Sale')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("daily-purchase", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="daily-purchase" name="daily-purchase" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="daily-purchase" name="daily-purchase">
							                    	<?php endif; ?>
								                    <label for="daily-purchase" class="padding05"><?php echo e(__('db.Daily Purchase')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
						                    	<div class="checkbox">
							                    	<?php if(in_array("monthly-purchase", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="monthly-purchase" name="monthly-purchase" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="monthly-purchase" name="monthly-purchase">
							                    	<?php endif; ?>
								                    <label for="monthly-purchase" class="padding05"><?php echo e(__('db.Monthly Purchase')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("product-report", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="product-report" name="product-report" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="product-report" name="product-report">
							                    	<?php endif; ?>
								                    <label for="product-report" class="padding05"><?php echo e(__('db.Product Report')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("payment-report", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="payment-report" name="payment-report" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="payment-report" name="payment-report">
							                    	<?php endif; ?>
								                    <label for="payment-report" class="padding05"><?php echo e(__('db.Payment Report')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("purchase-report", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="purchase-report" name="purchase-report" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="purchase-report" name="purchase-report">
							                    	<?php endif; ?>
								                    <label for="purchase-report" class="padding05"> <?php echo e(__('db.Purchase Report')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("sale-report", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="sale-report" name="sale-report" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="sale-report" name="sale-report">
							                    	<?php endif; ?>
								                    <label for="sale-report" class="padding05"><?php echo e(__('db.Sale Report')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("sale-report-chart", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="sale-report-chart" name="sale-report-chart" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="sale-report-chart" name="sale-report-chart">
							                    	<?php endif; ?>
								                    <label for="sale-report-chart" class="padding05"><?php echo e(__('db.Sale Report Chart')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
						                    	<div class="checkbox">
							                    	<?php if(in_array("warehouse-report", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="warehouse-report" name="warehouse-report" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="warehouse-report" name="warehouse-report">
							                    	<?php endif; ?>
								                    <label for="warehouse-report" class="padding05"><?php echo e(__('db.Warehouse Report')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
						                    	<div class="checkbox">
							                    	<?php if(in_array("warehouse-stock-report", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="warehouse-stock-report" name="warehouse-stock-report" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="warehouse-stock-report" name="warehouse-stock-report">
							                    	<?php endif; ?>
								                    <label for="warehouse-stock-report" class="padding05"><?php echo e(__('db.Warehouse Stock Chart')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
						                    	<div class="checkbox">
							                    	<?php if(in_array("product-expiry-report", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="product-expiry-report" name="product-expiry-report" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="product-expiry-report" name="product-expiry-report">
							                    	<?php endif; ?>
													<label for="product-expiry-report" class="padding05"><?php echo e(__('db.Product Expiry Report')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
								        </span>
								        <span>
						                    <div aria-checked="false" aria-disabled="false">
						                    	<div class="checkbox">
							                    	<?php if(in_array("dso-report", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="dso-report" name="dso-report" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="dso-report" name="dso-report">
							                    	<?php endif; ?>
													<label for="dso-report" class="padding05"><?php echo e(__('db.Daily Sale Objective Report')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
								        </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
						                    	<div class="checkbox">
							                    	<?php if(in_array("product-qty-alert", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="product-qty-alert" name="product-qty-alert" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="product-qty-alert" name="product-qty-alert">
							                    	<?php endif; ?>
													<label for="product-qty-alert" class="padding05"><?php echo e(__('db.Product Quantity Alert')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
								        </span>
								        <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("user-report", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="user-report" name="user-report" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="user-report" name="user-report">
							                    	<?php endif; ?>
								                    <label for="user-report" class="padding05"><?php echo e(__('db.User Report')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
										<span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("biller-report", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="biller-report" name="biller-report" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="biller-report" name="biller-report">
							                    	<?php endif; ?>
								                    <label for="biller-report" class="padding05"><?php echo e(__('db.Biller Report')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("customer-report", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="customer-report" name="customer-report" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="customer-report" name="customer-report">
							                    	<?php endif; ?>
								                    <label for="customer-report" class="padding05"><?php echo e(__('db.Customer Report')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("supplier-report", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="supplier-report" name="supplier-report" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="supplier-report" name="supplier-report">
							                    	<?php endif; ?>
								                    <label for="supplier-report" class="padding05"><?php echo e(__('db.Supplier Report')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("supplier-due-report", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="supplier-due-report" name="supplier-due-report" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="supplier-due-report" name="supplier-due-report">
							                    	<?php endif; ?>
								                    <label for="supplier-due-report" class="padding05"><?php echo e(__('db.Supplier Due Report')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("due-report", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="due-report" name="due-report" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="due-report" name="due-report">
							                    	<?php endif; ?>
								                    <label for="due-report" class="padding05"><?php echo e(__('db.Customer Due Report')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						            </td>
						        </tr>
								<tr class="addon-row">
									<td>Addonds</td>
									<td class="addons">
										<span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("addons", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="addons" name="addons" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="addons" name="addons">
							                    	<?php endif; ?>
								                    <label for="addons" class="padding05">Addons &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
									</td>
								</tr>
						        <tr>
						            <td><?php echo e(__('db.settings')); ?></td>
						            <td class="report-permissions" colspan="5">
						            	<span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("custom_field", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="custom_field" name="custom_field" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="custom_field" name="custom_field">
							                    	<?php endif; ?>
								                    <label for="custom_field" class="padding05"><?php echo e(__('db.Custom Field')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						            	<span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("all_notification", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="all_notification" name="all_notification" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="all_notification" name="all_notification">
							                    	<?php endif; ?>
								                    <label for="all_notification" class="padding05"><?php echo e(__('db.All Notification')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						            	<span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("send_notification", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="send_notification" name="send_notification" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="send_notification" name="send_notification">
							                    	<?php endif; ?>
								                    <label for="send_notification" class="padding05"><?php echo e(__('db.Send Notification')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("discount_plan", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="discount_plan" name="discount_plan" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="discount_plan" name="discount_plan">
							                    	<?php endif; ?>
								                    <label for="discount_plan" class="padding05"><?php echo e(__('db.Discount Plan')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("discount", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="discount" name="discount" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="discount" name="discount">
							                    	<?php endif; ?>
								                    <label for="discount" class="padding05"><?php echo e(__('db.Discount')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						            	<span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("warehouse", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="warehouse" name="warehouse" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="warehouse" name="warehouse">
							                    	<?php endif; ?>
								                    <label for="warehouse" class="padding05"><?php echo e(__('db.Warehouse')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						            	<span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("customer_group", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="customer_group" name="customer_group" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="customer_group" name="customer_group">
							                    	<?php endif; ?>
								                    <label for="customer_group" class="padding05"><?php echo e(__('db.Customer Group')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
								            <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("brand", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="brand" name="brand" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="brand" name="brand">
							                    	<?php endif; ?>
								                    <label for="brand" class="padding05"><?php echo e(__('db.Brand')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
								            <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("unit", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="unit" name="unit" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="unit" name="unit">
							                    	<?php endif; ?>
								                    <label for="unit" class="padding05"><?php echo e(__('db.Unit')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
								            <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("currency", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="currency" name="currency" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="currency" name="currency">
							                    	<?php endif; ?>
								                    <label for="currency" class="padding05"><?php echo e(__('db.Currency')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
								            <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("tax", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="tax" name="tax" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="tax" name="tax">
							                    	<?php endif; ?>
								                    <label for="tax" class="padding05"><?php echo e(__('db.Tax')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("backup_database", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="backup_database" name="backup_database" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="backup_database" name="backup_database">
							                    	<?php endif; ?>
								                    <label for="backup_database" class="padding05"><?php echo e(__('db.Backup Database')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						            	<span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("general_setting", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="general_setting" name="general_setting" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="general_setting" name="general_setting">
							                    	<?php endif; ?>
								                    <label for="general_setting" class="padding05"><?php echo e(__('db.General Setting')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("mail_setting", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="mail_setting" name="mail_setting" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="mail_setting" name="mail_setting">
							                    	<?php endif; ?>
								                    <label for="mail_setting" class="padding05"><?php echo e(__('db.Mail Setting')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("payment_gateway_setting", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="payment_gateway_setting" name="payment_gateway_setting" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="payment_gateway_setting" name="payment_gateway_setting">
							                    	<?php endif; ?>
								                    <label for="payment_gateway_setting" class="padding05">Payment Gateway &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("sms_setting", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="sms_setting" name="sms_setting" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="sms_setting" name="sms_setting">
							                    	<?php endif; ?>
								                    <label for="sms_setting" class="padding05"><?php echo e(__('db.SMS Setting')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("create_sms", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="create_sms" name="create_sms" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="create_sms" name="create_sms">
							                    	<?php endif; ?>
								                    <label for="create_sms" class="padding05"><?php echo e(__('db.Create SMS')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("pos_setting", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="pos_setting" name="pos_setting" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="pos_setting" name="pos_setting">
							                    	<?php endif; ?>
								                    <label for="pos_setting" class="padding05"><?php echo e(__('db.POS Setting')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span class="hrm-setting-section">
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("hrm_setting", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="hrm_setting" name="hrm_setting" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="hrm_setting" name="hrm_setting">
							                    	<?php endif; ?>
								                    <label for="hrm_setting" class="padding05"><?php echo e(__('db.HRM Setting')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span class="barcode_setting">
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("barcode_setting", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="barcode_setting" name="barcode_setting" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="barcode_setting" name="barcode_setting">
							                    	<?php endif; ?>
								                    <label for="barcode_setting" class="padding05">Barcode &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span class="language_setting">
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("language_setting", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="language_setting" name="language_setting" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="language_setting" name="language_setting">
							                    	<?php endif; ?>
								                    <label for="language_setting" class="padding05">Language &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("reward_point_setting", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="reward_point_setting" name="reward_point_setting" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="reward_point_setting" name="reward_point_setting">
							                    	<?php endif; ?>
								                    <label for="reward_point_setting" class="padding05"><?php echo e(__('db.Reward Point Setting')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("invoice_setting", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="invoice_setting" name="invoice_setting" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="invoice_setting" name="invoice_setting">
							                    	<?php endif; ?>
								                    <label for="invoice_setting" class="padding05"><?php echo e(__('db.Invoice Settings')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("invoice_create_edit_delete", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="invoice_create_edit_delete" name="invoice_create_edit_delete" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="invoice_create_edit_delete" name="invoice_create_edit_delete">
							                    	<?php endif; ?>
								                    <label for="invoice_create_edit_delete" class="padding05"><?php echo e(__('db.Invoice Create/Edit/Delete')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
                                        <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("role_permission", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="role_permission" name="role_permission" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="role_permission" name="role_permission">
							                    	<?php endif; ?>
								                    <label for="role_permission" class="padding05"><?php echo e(__('db.Role Permission')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						            </td>
						        </tr>
						        <tr>
						            <td><?php echo e(__('db.Miscellaneous')); ?></td>
						            <td class="report-permissions" colspan="5">
						            	<span>
								            <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("category", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="category" name="category" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="category" name="category">
							                    	<?php endif; ?>
								                    <label for="category" class="padding05"><?php echo e(__('db.category')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						            	</span>
                                        <span class="packing-slip-challan-section">
						            		<div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("packing_slip_challan", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="packing_slip_challan" name="packing_slip_challan" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="packing_slip_challan" name="packing_slip_challan">
							                    	<?php endif; ?>
								                    <label for="packing_slip_challan" class="padding05"><?php echo e(__('db.Packing Slip & Challan')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						            	</span>
						            	<span class="delivery-section">
						            		<div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("delivery", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="delivery" name="delivery" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="delivery" name="delivery">
							                    	<?php endif; ?>
								                    <label for="delivery" class="padding05"><?php echo e(__('db.Delivery')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						            	</span>
						            	<span class="stock-count-section">
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("stock_count", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="stock_count" name="stock_count" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="stock_count" name="stock_count">
							                    	<?php endif; ?>
								                    <label for="stock_count" class="padding05"><?php echo e(__('db.Stock Count')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span class="adjustment-section">
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("adjustment", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="adjustment" name="adjustment" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="adjustment" name="adjustment">
							                    	<?php endif; ?>
								                    <label for="adjustment" class="padding05"><?php echo e(__('db.Adjustment')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("gift_card", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="gift_card" name="gift_card" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="gift_card" name="gift_card">
							                    	<?php endif; ?>
								                    <label for="gift_card" class="padding05"><?php echo e(__('db.Gift Card')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("coupon", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="coupon" name="coupon" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="coupon" name="coupon">
							                    	<?php endif; ?>
								                    <label for="coupon" class="padding05"><?php echo e(__('db.Coupon')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("product_history", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="product_history" name="product_history" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="product_history" name="product_history">
							                    	<?php endif; ?>
								                    <label for="product_history" class="padding05"><?php echo e(__('db.Product History')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("print_barcode", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="print_barcode" name="print_barcode" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="print_barcode" name="print_barcode">
							                    	<?php endif; ?>
								                    <label for="print_barcode" class="padding05"><?php echo e(__('db.print_barcode')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("empty_database", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="empty_database" name="empty_database" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="empty_database" name="empty_database">
							                    	<?php endif; ?>
								                    <label for="empty_database" class="padding05"><?php echo e(__('db.Empty Database')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("today_sale", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="today_sale" name="today_sale" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="today_sale" name="today_sale">
							                    	<?php endif; ?>
								                    <label for="today_sale" class="padding05"><?php echo e(__('db.Today Sale')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("today_profit", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="today_profit" name="today_profit" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="today_profit" name="today_profit">
							                    	<?php endif; ?>
								                    <label for="today_profit" class="padding05"><?php echo e(__('db.Today Profit')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						                <span>
						                    <div aria-checked="false" aria-disabled="false">
								                <div class="checkbox">
							                    	<?php if(in_array("change_sale_date", $all_permission)): ?>
							                    	<input type="checkbox" value="1" id="change_sale_date" name="change_sale_date" checked>
							                    	<?php else: ?>
							                    	<input type="checkbox" value="1" id="change_sale_date" name="change_sale_date">
							                    	<?php endif; ?>
								                    <label for="change_sale_date" class="padding05"><?php echo e(__('db.Change Sale Date')); ?> &nbsp;&nbsp;</label>
								                </div>
								            </div>
						                </span>
						            </td>
						        </tr>
						        </tbody>
						    </table>
						</div>
						<div class="form-group">
	                        <input type="submit" value="<?php echo e(__('db.submit')); ?>" class="btn btn-primary">
	                    </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">

	$("ul#setting").siblings('a').attr('aria-expanded','true');
    $("ul#setting").addClass("show");
    $("ul#setting #role-menu").addClass("active");

    <?php if(config('database.connections.saleprosaas_landlord')): ?>
    	$.ajax({
        type: 'GET',
        async: false,
        url: '<?php echo e(route("package.fetchData", $general_setting->package_id)); ?>',
        success: function(data) {
            features = data['features'];
            console.log(features);

            if(!features.includes("sale_return"))
            	$("tr.sale-return-row").addClass('d-none');
            if(!features.includes("purchase_return"))
            	$("tr.purchase-return-row").addClass('d-none');
            if(!features.includes("expense"))
            	$("tr.expense-row").addClass('d-none');
            if(!features.includes("quotation"))
            	$("tr.quotation-row").addClass('d-none');
            if(!features.includes("transfer"))
            	$("tr.transfer-row").addClass('d-none');
            if(!features.includes("delivery"))
            	$("span.delivery-section").addClass('d-none');
            if(!features.includes("stock_count_and_adjustment")) {
            	$("span.stock-count-section").addClass('d-none');
            	$("span.adjustment-section").addClass('d-none');
            }
            if(!features.includes("report"))
            	$("tr.report-row").addClass('d-none');
            if(!features.includes("accounting"))
            	$("tr.accounting-row").addClass('d-none');
            if(!features.includes("hrm")) {
            	$("tr.employee-row").addClass('d-none');
            	$("tr.hrm-row").addClass('d-none');
            	$("span.hrm-setting-section").addClass('d-none');
            }
            if(!features.includes("manufacturing") && !features.includes("woocommerce") && !features.includes("ecommerce") && !features.includes("restaurant"))
                $("tr.addon-row").addClass('d-none');
        }
    });
    <?php endif; ?>

	$("#select_all").on( "change", function() {
	    if ($(this).is(':checked')) {
	        $("tbody input[type='checkbox']").prop('checked', true);
	    }
	    else {
	        $("tbody input[type='checkbox']").prop('checked', false);
	    }
	});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xamppp\htdocs\Script\resources\views/backend/role/permission.blade.php ENDPATH**/ ?>