<?php
    $department_active     = $role_has_permissions_list->where('name', 'department')->first();
    $designations_active   = $role_has_permissions_list->where('name', 'designations')->first();
    $shift_active          = $role_has_permissions_list->where('name', 'shift')->first();
    $overtime_active       = $role_has_permissions_list->where('name', 'overtime')->first();
    $leave_type_active     = $role_has_permissions_list->where('name', 'leave-type')->first();
    $leave_active          = $role_has_permissions_list->where('name', 'leave')->first();
    $hrm_panel_active      = $role_has_permissions_list->where('name', 'hrm-panel')->first();
    $sale_agent_active     = $role_has_permissions_list->where('name', 'sale-agents')->first();

    $index_employee_active = $role_has_permissions_list->where('name', 'employees-index')->first();
    $attendance_active     = $role_has_permissions_list->where('name', 'attendance')->first();
    $payroll_active        = $role_has_permissions_list->where('name', 'payroll')->first();
    $holiday_active        = $role_has_permissions_list->where('name', 'holiday')->first();
?>

<section class="no-print mb-4">
    <nav class="navbar navbar-expand-lg navbar-light bg-white border rounded shadow-sm mt-3 mx-3">
        <div class="container-fluid" style="background: #fffcf2">

            <a class="navbar-brand font-weight-bold text-primary" href="<?php echo e(route('hrm-panel')); ?>">
                <i class="dripicons-wallet mr-2"></i> <?php echo e(__("db.HRM")); ?>

            </a>

            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#hrmNavbar">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="hrmNavbar">
                <ul class="navbar-nav">

                    <?php if($index_employee_active): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('employees.index') ? 'active' : ''); ?>"
                           href="<?php echo e(route('employees.index')); ?>">
                            <i class="dripicons-clock mr-1"></i> <?php echo e(__("db.Employees")); ?>

                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if($payroll_active): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('payroll.index') ? 'active' : ''); ?>"
                           href="<?php echo e(route('payroll.index')); ?>">
                            <i class="dripicons-wallet mr-1"></i> <?php echo e(__("db.Payroll")); ?>

                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if($attendance_active): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('attendance.index') ? 'active' : ''); ?>"
                           href="<?php echo e(route('attendance.index')); ?>">
                            <i class="dripicons-time-reverse mr-1"></i> <?php echo e(__("db.Attendance")); ?>

                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if($leave_type_active): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('leave-type.index') ? 'active' : ''); ?>"
                           href="<?php echo e(route('leave-type.index')); ?>">
                            <i class="dripicons-briefcase mr-1"></i> <?php echo e(__("db.Leave Type")); ?>

                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if($leave_active): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('leave.index') ? 'active' : ''); ?>"
                           href="<?php echo e(route('leave.index')); ?>">
                            <i class="dripicons-to-do mr-1"></i> <?php echo e(__("db.Leaves")); ?>

                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if($holiday_active): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('holidays.index') ? 'active' : ''); ?>"
                           href="<?php echo e(route('holidays.index')); ?>">
                            <i class="dripicons-calendar mr-1"></i> <?php echo e(__("db.Holiday")); ?>

                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if($shift_active): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('shift.index') ? 'active' : ''); ?>"
                           href="<?php echo e(route('shift.index')); ?>">
                            <i class="dripicons-calendar mr-1"></i> <?php echo e(__("db.Shift")); ?>

                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if($overtime_active): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('overtime.index') ? 'active' : ''); ?>"
                           href="<?php echo e(route('overtime.index')); ?>">
                            <i class="dripicons-briefcase mr-1"></i> <?php echo e(__("db.Overtime")); ?>

                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>
</section>

<style>
    section {
    padding: 0px !important;
}
.navbar-nav .nav-link {
    color: #444;
    font-weight: 500;
    transition: all 0.3s ease;
    border-radius: 5px;
}
.navbar-nav .nav-link:hover {
    background-color: #f5f7ff;
    color: #007bff;
}
.navbar-nav .nav-link.active {
    color: #0798bd !important;
    font-weight: 700;
}
</style>
<?php /**PATH C:\xamppp\htdocs\Script\resources\views/backend/hrm/partial/menu.blade.php ENDPATH**/ ?>